//
//  basicTabViewController.h
//  LEDArray
//
//  Created by Brian Burley on 2026-01-15.
//

#import <Cocoa/Cocoa.h>
#import <Phidget22/phidget22.h>

NS_ASSUME_NONNULL_BEGIN

@class basicTabViewController;

@protocol TabResizingDelegate <NSObject>
- (void)tabDidRequestResize:(NSSize)size;
@end

@protocol basicTabViewControllerDelegate <NSObject>
- (void)basicTabViewController:(basicTabViewController *)controller
                didSelectColor:(NSColor *)color
                      integers:(NSArray<NSNumber *> *)integers;
@end


@interface basicTabViewController : NSViewController

//controls
@property (weak) IBOutlet NSTextField *startAddressField;
@property (weak) IBOutlet NSStepper *startUpDown;
@property (weak) IBOutlet NSTextField *endAddressField;
@property (weak) IBOutlet NSStepper *endUpDown;
@property (weak) IBOutlet NSImageView *colorBox;
@property (weak) IBOutlet NSTextField *colorHexBox;

//properties
@property (nonatomic, assign, readonly) NSInteger startAddress;
@property (nonatomic, assign, readonly) NSInteger endAddress;


//special
@property (weak) id<TabResizingDelegate> resizeDelegate;
@property (nonatomic, weak) id<basicTabViewControllerDelegate> delegate;
@end




NS_ASSUME_NONNULL_END
