//
//  advancedTabViewController.h
//  LEDArray
//
//  Created by Brian Burley on 2026-01-15.
//

#import <Cocoa/Cocoa.h>
#import "ledColorEntryRow.h"
#import "colorCellView.h"

NS_ASSUME_NONNULL_BEGIN
@class advancedTabViewController;

@protocol TabResizingDelegate2 <NSObject>
- (void)tabDidRequestResize:(NSSize)size;
@end

@protocol AdvancedTabViewControllerDelegate <NSObject>
- (void)advancedTab:(advancedTabViewController *)controller
     didSendColors:(NSArray<ledColorEntryRow *> *)entries
      startAddress:(NSInteger)startAddress
        endAddress:(NSInteger)endAddress
          fadeTime:(NSInteger)fadeTime
          ledCount:(NSInteger)ledCount;
@end

@interface advancedTabViewController : NSViewController

@property (weak) IBOutlet NSTextField *advStarAddr;
@property (weak) IBOutlet NSStepper *advStartUpDown;
@property (weak) IBOutlet NSTextField *advEndAddress;
@property (weak) IBOutlet NSStepper *advEndUpDown;
@property (weak) IBOutlet NSTableView *patternBuilderTable;
@property (weak) IBOutlet NSButton *patternAddRow;
@property (weak) IBOutlet NSButton *patternRemoveRow;
@property (weak) IBOutlet NSTextField *fadeTimeTxt;
@property (weak) IBOutlet NSButton *sendPatternBtn;

@property (nonatomic, assign) NSInteger colorPanelRow;

//properties
@property (nonatomic, assign) NSInteger ledCount;

@property (weak) id<TabResizingDelegate2> resizeDelegate;
@property (nonatomic, weak) id<AdvancedTabViewControllerDelegate> delegate;

@end

NS_ASSUME_NONNULL_END
