//
//  ViewController.h
//  LEDArray
//
//  Created by Brian Burley on 2025-02-24.
//

#import <Cocoa/Cocoa.h>
#import <Phidget22/phidget22.h>
//#import "PhidgetInfoBox.h"
#import "PhidgetInfoBoxN.h"
#import "basicTabViewController.h"
#import "advancedTabViewController.h"
#import "ledColorEntryRow.h"
#import "colorCellView.h"
@class basicTabViewController;
@class advancedTabViewController;

@interface LEDArrayController : NSViewController <NSTableViewDelegate, NSTableViewDataSource>
{
    //global
    IBOutlet NSView *mainWindowView;
    IBOutlet NSWindow *window;
    
    PhidgetLEDArrayHandle ch;
    
    //phidget info box
    IBOutlet NSBox *phidgetInfoBox;
    __weak IBOutlet NSView *phidgetInfoView;
    
    //general configuration
    __weak IBOutlet NSBox *configBox;
    __weak IBOutlet NSComboBox *colorOrderCmb;
    __weak IBOutlet NSSlider *gammaTrk;
    __weak IBOutlet NSTextField *gammaTxt;
    __weak IBOutlet NSButton *powerBtn;
    __weak IBOutlet NSButton *clearBtn;
    __weak IBOutlet NSSlider *brightnessTrk;
    
    //errors
    IBOutlet NSTextView *errorEventLog;
    IBOutlet NSTextField *errorEventLogCounter;
    
}

@property (strong) NSWindowController *errorEventLogWindow;
@property (strong) PhidgetInfoBoxN *infoBoxVC;

@property (weak) NSTabViewController *tabViewController; //for the config tabs


@end
