//
//  DataAdapterController.h
//  DataAdapter
//
//  Created by Brian Burley on 2025-02-24.
//

#import <Cocoa/Cocoa.h>
#import <Phidget22/phidget22.h>
//#import "PhidgetInfoBox.h"
#import "PhidgetInfoBoxN.h"

@interface DataAdapterController : NSViewController <NSTableViewDelegate, NSTableViewDataSource>
{
    //global
    IBOutlet NSView *mainWindowView;
    IBOutlet NSWindow *window;
    
    bool isSPI;
    
    PhidgetDataAdapterHandle ch;
    
    //phidget info box
    IBOutlet NSBox *phidgetInfoBox;
    __weak IBOutlet NSView *phidgetInfoView;
    
    //configuration
    IBOutlet NSBox *configBox;
    IBOutlet NSBox *spiPanel;
    IBOutlet NSPopUpButton *voltageCombo;
    IBOutlet NSPopUpButton *frequencyCombo;
    IBOutlet NSPopUpButton *modeCombo;
    IBOutlet NSPopUpButton *chipselectCombo;
    IBOutlet NSButton *msbRadio;
    IBOutlet NSButton *lsbRadio;
    IBOutlet NSBox *endiannessPanel;
    
    //controls
    IBOutlet NSBox *controlsBox;
    IBOutlet NSBox *addressPanel;
    IBOutlet NSTextField *addressTxt;
    
    IBOutlet NSTableView *txTable;
    NSMutableArray *txCommands;
    
    IBOutlet NSButton *addRow;
    IBOutlet NSButton *removeRow;
    
    //received
    IBOutlet NSBox *receivedBox;
    IBOutlet NSTableView *rxTable;
    NSMutableArray *rxCommands;
    IBOutlet NSButton *clearRxTable;
    
    //errors
    IBOutlet NSTextView *errorEventLog;
    IBOutlet NSTextField *errorEventLogCounter;
}

@property (strong) NSWindowController *errorEventLogWindow;
@property (strong) PhidgetInfoBoxN *infoBoxVC;

@end
