/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.NetServerAddedEvent;
import com.phidget22.NetServerAddedListener;
import com.phidget22.NetServerRemovedEvent;
import com.phidget22.NetServerRemovedListener;
import com.phidget22.PhidgetException;
import com.phidget22.ServerType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetBase {
    private List<NetServerAddedListener> serverAddedListeners = new ArrayList<NetServerAddedListener>();
    private long nativeServerAddedHandler = 0L;
    private List<NetServerRemovedListener> serverRemovedListeners = new ArrayList<NetServerRemovedListener>();
    private long nativeServerRemovedHandler = 0L;
    public static final int AUTHREQUIRED = 1;

    private final void setEvents(boolean bl) {
        this.enableServerAddedEvents(bl && this.serverAddedListeners.size() > 0);
        this.enableServerRemovedEvents(bl && this.serverRemovedListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerAddedListener(NetServerAddedListener netServerAddedListener) {
        List<NetServerAddedListener> list = this.serverAddedListeners;
        synchronized (list) {
            this.serverAddedListeners.add(netServerAddedListener);
            this.enableServerAddedEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerAddedListener(NetServerAddedListener netServerAddedListener) {
        List<NetServerAddedListener> list = this.serverAddedListeners;
        synchronized (list) {
            this.serverAddedListeners.remove(netServerAddedListener);
            this.enableServerAddedEvents(this.serverAddedListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerAdded(NetServerAddedEvent netServerAddedEvent) {
        List<NetServerAddedListener> list = this.serverAddedListeners;
        synchronized (list) {
            Iterator<NetServerAddedListener> iterator = this.serverAddedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServerAdded(netServerAddedEvent);
            }
        }
    }

    private native void enableServerAddedEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerRemovedListener(NetServerRemovedListener netServerRemovedListener) {
        List<NetServerRemovedListener> list = this.serverRemovedListeners;
        synchronized (list) {
            this.serverRemovedListeners.add(netServerRemovedListener);
            this.enableServerRemovedEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerRemovedListener(NetServerRemovedListener netServerRemovedListener) {
        List<NetServerRemovedListener> list = this.serverRemovedListeners;
        synchronized (list) {
            this.serverRemovedListeners.remove(netServerRemovedListener);
            this.enableServerRemovedEvents(this.serverRemovedListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerRemoved(NetServerRemovedEvent netServerRemovedEvent) {
        List<NetServerRemovedListener> list = this.serverRemovedListeners;
        synchronized (list) {
            Iterator<NetServerRemovedListener> iterator = this.serverRemovedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServerRemoved(netServerRemovedEvent);
            }
        }
    }

    private native void enableServerRemovedEvents(boolean var1);

    public static native void addServer(String var0, String var1, int var2, String var3, int var4) throws PhidgetException;

    public static native void removeServer(String var0) throws PhidgetException;

    public static native void enableServer(String var0) throws PhidgetException;

    public static native void disableServer(String var0, int var1) throws PhidgetException;

    public static native void enableServerDiscovery(ServerType var0) throws PhidgetException;

    public static native void disableServerDiscovery(ServerType var0) throws PhidgetException;

    public static native void setServerPassword(String var0, String var1) throws PhidgetException;

    static {
        try {
            System.loadLibrary("phidget22");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("phidget22java");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries (libphidget22.so and libphidget22java.so)." + "\nMake sure they are available, and add their path to LD_LIBRARY_PATH, or specify with java.library.path.");
            }
            if (string.startsWith("Windows")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries." + "\nInstall the Windows Phidget22 MSI, or specify with java.library.path.");
            }
            if (string.startsWith("Mac")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries." + "\nThe Mac Phidget22 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries.");
        }
    }
}

