/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.phidget22.usb.Phidget;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Manager {
    private static final String ACTION_USB_PERMISSION = "com.phidgets.usb.USB_PERMISSION";
    private static UsbManager manager;
    private static Context appContext;
    private static PendingIntent mPermissionIntent;
    private static ArrayList<Phidget> phidgetList;
    private static ArrayList<String> askedPermissionList;
    static boolean pendingPermissionRequest;
    private static Object sync;
    private static final BroadcastReceiver mUsbReceiver;
    private static final BroadcastReceiver mUsbDetachReceiver;
    static boolean usingPhidgetListFromC;

    private static final native boolean getInitialized();

    private static final native void setInitialized(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Initialize(Context userContext) {
        Object object = sync;
        synchronized (object) {
            appContext = userContext.getApplicationContext();
            manager = (UsbManager)appContext.getSystemService("usb");
            mPermissionIntent = PendingIntent.getBroadcast((Context)appContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            appContext.registerReceiver(mUsbReceiver, filter);
            IntentFilter filter2 = new IntentFilter();
            filter2.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            appContext.registerReceiver(mUsbDetachReceiver, filter2);
            usingPhidgetListFromC = false;
            Manager.setInitialized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Uninitialize() {
        Object object = sync;
        synchronized (object) {
            if (Manager.getInitialized()) {
                appContext.unregisterReceiver(mUsbReceiver);
                appContext.unregisterReceiver(mUsbDetachReceiver);
                mPermissionIntent = null;
                Manager.setInitialized(false);
                ArrayList<Phidget> arrayList = phidgetList;
                synchronized (arrayList) {
                    phidgetList.clear();
                    usingPhidgetListFromC = false;
                }
                appContext = null;
                manager = null;
            }
        }
    }

    public static String getStringDescriptorFromByteArray(byte[] array) {
        int strLength = array[0] - 2;
        if (array.length < strLength + 2) {
            return null;
        }
        byte[] strArray = new byte[strLength];
        for (int i = 0; i < strLength; ++i) {
            strArray[i] = array[i + 2];
        }
        try {
            String str = new String(strArray, "UTF16LE");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getStringDescriptor(UsbDeviceConnection conn, int stringIndex) {
        byte[] stringDesc = new byte[256];
        int bytesRecieved = conn.controlTransfer(128, 6, 0x300 | stringIndex, 1033, stringDesc, 2, 500);
        if (bytesRecieved == 2) {
            bytesRecieved = conn.controlTransfer(128, 6, 0x300 | stringIndex, 1033, stringDesc, (int)stringDesc[0], 500);
            if (bytesRecieved >= 0) {
                return Manager.getStringDescriptorFromByteArray(stringDesc);
            }
            return null;
        }
        return null;
    }

    public static byte[] getDeviceDescriptor(UsbDeviceConnection conn, int type, int index) {
        byte[] desc = new byte[256];
        int bytesRecieved = conn.controlTransfer(128, 6, type << 8 | index, 0, desc, 2, 500);
        if (bytesRecieved == 2) {
            bytesRecieved = conn.controlTransfer(128, 6, type << 8 | index, 0, desc, (int)desc[0], 500);
            if (bytesRecieved < 0) {
                return null;
            }
            byte[] data = new byte[bytesRecieved];
            for (int k = 0; k < bytesRecieved; ++k) {
                data[k] = desc[k];
            }
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phidget[] getPhidgetList() {
        if (!Manager.getInitialized()) {
            return null;
        }
        if (!usingPhidgetListFromC) {
            Manager.updatePhidgetList();
            ArrayList<Phidget> arrayList = phidgetList;
            synchronized (arrayList) {
                usingPhidgetListFromC = true;
                Phidget[] list = new Phidget[phidgetList.size()];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = phidgetList.get(i);
                }
                return list;
            }
        }
        return null;
    }

    public static void doneWithPhidgetList() {
        if (usingPhidgetListFromC) {
            usingPhidgetListFromC = false;
        }
    }

    public static String getDescriptor(String deviceName, int interfaceNumber, int index) {
        for (UsbDevice device : manager.getDeviceList().values()) {
            if (!device.getDeviceName().equals(deviceName)) continue;
            return Manager.getStringDescriptorFromUsbDevice(device, interfaceNumber, index);
        }
        return null;
    }

    private static String getStringDescriptorFromUsbDevice(UsbDevice device, int interfaceNumber, int strIdx) {
        UsbInterface intf = device.getInterface(interfaceNumber);
        int interfaceClass = intf.getInterfaceClass();
        if (interfaceClass == 3 || interfaceClass == 255) {
            if (!manager.hasPermission(device)) {
                if (!askedPermissionList.contains(device.getDeviceName()) && !pendingPermissionRequest) {
                    askedPermissionList.add(device.getDeviceName());
                    pendingPermissionRequest = true;
                    manager.requestPermission(device, mPermissionIntent);
                } else {
                    return null;
                }
            }
            if (manager.hasPermission(device)) {
                UsbDeviceConnection connection = manager.openDevice(device);
                if (connection != null) {
                    String str = Manager.getStringDescriptor(connection, strIdx);
                    connection.close();
                    return str;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static byte[] getDeviceDescriptor(String deviceName, int interfaceNumber, int type, int index) {
        for (UsbDevice device : manager.getDeviceList().values()) {
            if (!device.getDeviceName().equals(deviceName)) continue;
            return Manager.getDeviceDescriptorFromUsbDevice(device, interfaceNumber, type, index);
        }
        return null;
    }

    private static byte[] getDeviceDescriptorFromUsbDevice(UsbDevice device, int interfaceNumber, int type, int index) {
        UsbInterface intf = device.getInterface(interfaceNumber);
        int interfaceClass = intf.getInterfaceClass();
        if (interfaceClass == 3 || interfaceClass == 255) {
            if (!manager.hasPermission(device)) {
                if (!askedPermissionList.contains(device.getDeviceName()) && !pendingPermissionRequest) {
                    askedPermissionList.add(device.getDeviceName());
                    pendingPermissionRequest = true;
                    manager.requestPermission(device, mPermissionIntent);
                } else {
                    return null;
                }
            }
            if (manager.hasPermission(device)) {
                UsbDeviceConnection connection = manager.openDevice(device);
                if (connection != null) {
                    byte[] desc = Manager.getDeviceDescriptor(connection, type, index);
                    connection.close();
                    return desc;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static Phidget openPhidget(String deviceName, int interfaceNumber) {
        for (UsbDevice device : manager.getDeviceList().values()) {
            if (!device.getDeviceName().equals(deviceName)) continue;
            return Manager.getPhidgetFromUsbDevice(device, interfaceNumber, true);
        }
        return null;
    }

    private static boolean readPHIDUSBDeviceParams(Phidget phidget, UsbDeviceConnection conn) {
        phidget.labelIndex = 0;
        phidget.skuIndex = 0;
        phidget.maxPacketEP0 = 0;
        phidget.maxPacketEP1 = 0;
        phidget.wMaxPacketSizeEP1 = 0;
        phidget.maxPacketEP2 = 0;
        phidget.ep1type = 0;
        phidget.ep2type = 0;
        byte[] configDescriptor = new byte[256];
        int bytesRecieved = conn.controlTransfer(128, 6, 512, 0, configDescriptor, 256, 500);
        if (bytesRecieved < 9) {
            return false;
        }
        int wTotalLength = ((configDescriptor[3] & 0xFF) << 8 | configDescriptor[2] & 0xFF) & 0xFFFF;
        if (bytesRecieved != wTotalLength) {
            return false;
        }
        EndpointDescriptor endpointDesc = null;
        PhidgetDeviceDescriptor phidgetDeviceDesc = null;
        PhidgetEndpointDescriptor phidgetEndpointDesc = null;
        int i = 0;
        while (i + 2 < wTotalLength && i + (configDescriptor[i] & 0xFF) <= wTotalLength) {
            switch (configDescriptor[i + 1] & 0xFF) {
                case 2: {
                    if (configDescriptor[i] == 9) break;
                    return false;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (configDescriptor[i] != 7) {
                        return false;
                    }
                    endpointDesc = new EndpointDescriptor();
                    endpointDesc.bLength = configDescriptor[i] & 0xFF;
                    endpointDesc.bDescriptorType = configDescriptor[i + 1] & 0xFF;
                    endpointDesc.bEndpointAddress = configDescriptor[i + 2] & 0xFF;
                    endpointDesc.bmAttributes = configDescriptor[i + 3] & 0xFF;
                    endpointDesc.wMaxPacketSize = ((configDescriptor[i + 5] & 0xFF) << 8 | configDescriptor[i + 4] & 0xFF) & 0xFFFF;
                    endpointDesc.bInterval = configDescriptor[i + 6] & 0xFF;
                    if (endpointDesc.bEndpointAddress == 129) {
                        phidget.wMaxPacketSizeEP1 = endpointDesc.wMaxPacketSize;
                        if (endpointDesc.bmAttributes == 2) {
                            phidget.ep1type = 1;
                        }
                        if (endpointDesc.bmAttributes == 3) {
                            phidget.ep1type = 2;
                        }
                    }
                    if (endpointDesc.bEndpointAddress != 2) break;
                    phidget.maxPacketEP2 = endpointDesc.wMaxPacketSize;
                    phidget.ep2type = 1;
                    break;
                }
                case 64: {
                    if (configDescriptor[i] != 8) {
                        return false;
                    }
                    phidgetDeviceDesc = new PhidgetDeviceDescriptor();
                    phidgetDeviceDesc.bLength = configDescriptor[i] & 0xFF;
                    phidgetDeviceDesc.bDescriptorType = configDescriptor[i + 1] & 0xFF;
                    phidgetDeviceDesc.bcdVersion = ((configDescriptor[i + 3] & 0xFF) << 8 | configDescriptor[i + 2] & 0xFF) & 0xFFFF;
                    phidgetDeviceDesc.iLabel = configDescriptor[i + 4] & 0xFF;
                    phidgetDeviceDesc.iSKU = configDescriptor[i + 5] & 0xFF;
                    phidgetDeviceDesc.wMaxPacketSize = ((configDescriptor[i + 7] & 0xFF) << 8 | configDescriptor[i + 6] & 0xFF) & 0xFFFF;
                    if (phidgetDeviceDesc.bcdVersion != 272) {
                        return false;
                    }
                    phidget.labelIndex = phidgetDeviceDesc.iLabel;
                    phidget.skuIndex = phidgetDeviceDesc.iSKU;
                    phidget.maxPacketEP0 = phidgetDeviceDesc.wMaxPacketSize;
                    break;
                }
                case 66: {
                    if (configDescriptor[i] != 4) {
                        return false;
                    }
                    phidgetEndpointDesc = new PhidgetEndpointDescriptor();
                    phidgetEndpointDesc.bLength = configDescriptor[i] & 0xFF;
                    phidgetEndpointDesc.bDescriptorType = configDescriptor[i + 1] & 0xFF;
                    phidgetEndpointDesc.wMaxPacketSize = ((configDescriptor[i + 3] & 0xFF) << 8 | configDescriptor[i + 2] & 0xFF) & 0xFFFF;
                    if (endpointDesc == null) {
                        return false;
                    }
                    if ((endpointDesc.bEndpointAddress & 0x7F) == 1) {
                        phidget.maxPacketEP1 = phidgetEndpointDesc.wMaxPacketSize;
                    }
                    if ((endpointDesc.bEndpointAddress & 0x7F) != 2) break;
                    phidget.maxPacketEP2 = phidgetEndpointDesc.wMaxPacketSize;
                    break;
                }
            }
            i += configDescriptor[i] & 0xFF;
        }
        phidget.inputReportSize = phidget.maxPacketEP1;
        phidget.outputReportSize = phidget.maxPacketEP2;
        phidget.skuString = Manager.getStringDescriptor(conn, phidget.skuIndex);
        return true;
    }

    private static Phidget getPhidgetFromUsbDevice(UsbDevice device, int interfaceNumber) {
        return Manager.getPhidgetFromUsbDevice(device, interfaceNumber, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Phidget getPhidgetFromUsbDevice(UsbDevice device, int interfaceNumber, boolean open) {
        UsbInterface intf = device.getInterface(interfaceNumber);
        int interfaceClass = intf.getInterfaceClass();
        if (interfaceClass != 3 && interfaceClass != 255) return null;
        Phidget phidget = null;
        if (!manager.hasPermission(device)) {
            if (askedPermissionList.contains(device.getDeviceName()) || pendingPermissionRequest) return null;
            askedPermissionList.add(device.getDeviceName());
            pendingPermissionRequest = true;
            manager.requestPermission(device, mPermissionIntent);
        }
        if (!manager.hasPermission(device)) return null;
        UsbDeviceConnection connection = manager.openDevice(device);
        if (connection == null) return null;
        phidget = new Phidget();
        byte[] deviceDescriptor = new byte[18];
        int bytesRecieved = connection.controlTransfer(128, 6, 256, 0, deviceDescriptor, 18, 500);
        if (bytesRecieved != 18) {
            return null;
        }
        int versionLow = 0xFF & deviceDescriptor[12];
        int versionHigh = 0xFF & deviceDescriptor[13];
        int version = versionLow + (versionHigh & 0xFF) * 256;
        phidget.version = interfaceClass == 3 ? (version < 256 ? version * 100 : (version >> 8) * 100 + (version & 0xFF)) : (version >> 12 & 0xF) * 1000 + (version >> 8 & 0xF) * 100 + (version >> 4 & 0xF) * 10 + (version & 0xF);
        byte productStringIndex = deviceDescriptor[15];
        byte serialStringIndex = deviceDescriptor[16];
        String serialNumber = Manager.getStringDescriptor(connection, serialStringIndex);
        if (serialNumber == null) {
            return null;
        }
        phidget.serialNumber = Integer.parseInt(serialNumber);
        phidget.productString = Manager.getStringDescriptor(connection, productStringIndex);
        phidget.interfaceClass = interfaceClass;
        if (interfaceClass == 255 && !Manager.readPHIDUSBDeviceParams(phidget, connection)) {
            return null;
        }
        Phidget.refreshLabel(phidget, connection);
        if (open) {
            if (!connection.claimInterface(intf, true)) return null;
            if (interfaceClass == 3) {
                byte[] hidReportDesc = new byte[256];
                bytesRecieved = connection.controlTransfer(129, 6, 8704, 0, hidReportDesc, hidReportDesc.length, 500);
                if (bytesRecieved == -1) {
                    return null;
                }
                for (int j = 10; j < bytesRecieved; ++j) {
                    if (hidReportDesc[j] == -127 && hidReportDesc[j - 2] == -107) {
                        phidget.inputReportSize = hidReportDesc[j - 1];
                    }
                    if (hidReportDesc[j] != -111 || hidReportDesc[j - 2] != -107) continue;
                    phidget.outputReportSize = hidReportDesc[j - 1];
                }
            }
            if (!phidget.setDeviceAndConnection(device, connection, intf)) {
                return null;
            }
        } else {
            connection.close();
        }
        phidget.vID = device.getVendorId();
        phidget.pID = device.getProductId();
        phidget.interfaceNum = interfaceNumber;
        phidget.id = device.getDeviceId();
        phidget.name = device.getDeviceName();
        return phidget;
    }

    private static boolean listContainsDeviceInterface(UsbDevice device, int interfaceNum) {
        for (int i = 0; i < phidgetList.size(); ++i) {
            Phidget phidget = phidgetList.get(i);
            if (!phidget.name.equals(device.getDeviceName()) || phidget.interfaceNum != interfaceNum) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPhidgetsFromUsbDevice(UsbDevice device) {
        if (device.getVendorId() == 1730) {
            int count = device.getInterfaceCount();
            for (int i = 0; i < count; ++i) {
                ArrayList<Phidget> arrayList = phidgetList;
                synchronized (arrayList) {
                    Phidget phidget;
                    while (usingPhidgetListFromC) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!Manager.listContainsDeviceInterface(device, i) && (phidget = Manager.getPhidgetFromUsbDevice(device, i)) != null) {
                        phidgetList.add(phidget);
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeDeviceFromList(UsbDevice device) {
        if (device.getVendorId() == 1730) {
            int count = device.getInterfaceCount();
            for (int i = 0; i < count; ++i) {
                ArrayList<Phidget> arrayList = phidgetList;
                synchronized (arrayList) {
                    while (usingPhidgetListFromC) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (askedPermissionList.contains(device.getDeviceName())) {
                        askedPermissionList.remove(device.getDeviceName());
                    }
                    Phidget phidgetToRemove = null;
                    for (int j = 0; j < phidgetList.size(); ++j) {
                        Phidget phidget = phidgetList.get(j);
                        if (!phidget.name.equals(device.getDeviceName()) || phidget.interfaceNum != i) continue;
                        phidgetToRemove = phidget;
                        break;
                    }
                    if (phidgetToRemove != null) {
                        phidgetList.remove(phidgetToRemove);
                    }
                    continue;
                }
            }
        }
    }

    private static void updatePhidgetList() {
        for (UsbDevice device : manager.getDeviceList().values()) {
            Manager.addPhidgetsFromUsbDevice(device);
        }
    }

    static {
        try {
            System.loadLibrary("phidget22java");
        }
        catch (UnsatisfiedLinkError ex) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Linux")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library (libphidget22java.so).\nMake sure it is installed, and add it' s path to LD_LIBRARY_PATH.");
            }
            if (os.startsWith("Windows")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.\nThe Windows Phidget22 MSI must be installed.");
            }
            if (os.startsWith("Mac")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.\nThe Mac Phidget22 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.");
        }
        phidgetList = new ArrayList();
        askedPermissionList = new ArrayList();
        pendingPermissionRequest = false;
        sync = new Object();
        mUsbReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (Manager.ACTION_USB_PERMISSION.equals(action)) {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (!intent.getBooleanExtra("permission", false)) {
                            Log.d((String)"PhidgetUSB", (String)("permission denied for device " + device));
                        }
                        pendingPermissionRequest = false;
                    }
                }
            }
        };
        mUsbDetachReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                    2 var4_4 = this;
                    synchronized (var4_4) {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        Manager.removeDeviceFromList(device);
                    }
                }
            }
        };
        usingPhidgetListFromC = false;
    }

    static class PhidgetEndpointDescriptor {
        public int bLength = 0;
        public int bDescriptorType = 0;
        public int wMaxPacketSize = 0;

        PhidgetEndpointDescriptor() {
        }
    }

    static class PhidgetDeviceDescriptor {
        public int bLength = 0;
        public int bDescriptorType = 0;
        public int bcdVersion = 0;
        public int iLabel = 0;
        public int iSKU = 0;
        public int wMaxPacketSize = 0;

        PhidgetDeviceDescriptor() {
        }
    }

    static class EndpointDescriptor {
        public int bLength = 0;
        public int bDescriptorType = 0;
        public int bEndpointAddress = 0;
        public int bmAttributes = 0;
        public int wMaxPacketSize = 0;
        public int bInterval = 0;

        EndpointDescriptor() {
        }
    }
}

